assert(load(assert(builder:open_text("setup_utility.lua"))))()
builder:set_default_size(30, 30)
standard_setup({
  blocks = {"Red.png", "Blue.png", "Green.png"},
  main = {"advanced_level_utility.lua", "level_logic.lua"},
  extra_keys = true,
  info_panel = {
    {tab = "Goal", contents = {
      info_title("Specification"),
      low_level_figure({
        {text = "Input", height = 0.06, position = Vectord.new(-0.5, 0.15), color = {1, 1, 1, 0.5}},
        {text = "Last Output", height = 0.06, position = Vectord.new(0, 0.15), color = {1, 1, 1, 0.5}},
        {text = "Output", height = 0.06, position = Vectord.new(0.5, 0.15), color = {1, 1, 1, 0.5}},

        {object = "triangle", height = 0.2, position = Vectord.new(-0.35, 0), align_horizontal = ALIGN_UPPER},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0.25, 0)},
        {text = "(none)", height = 0.07, position = Vectord.new(0.0, 0), color = {1, 1, 1, 0.6}},
        {object = "blue", height = 0.1, position = Vectord.new(0.5, 0)},

        {object = "triangle", height = 0.2, position = Vectord.new(-0.35, -0.25), align_horizontal = ALIGN_UPPER},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0.25, -0.25)},
        {object = "blue", height = 0.1, position = Vectord.new(0.0, -0.25)},
        {object = "blue", height = 0.1, position = Vectord.new(0.5, -0.25)},

        {object = "triangle", height = 0.2, position = Vectord.new(-0.35, -0.5), align_horizontal = ALIGN_UPPER},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0.25, -0.5)},
        {object = "green", height = 0.1, position = Vectord.new(0.0, -0.5)},
        {object = "green", height = 0.1, position = Vectord.new(0.5, -0.5)},

        {object = "square", height = 0.2, position = Vectord.new(-0.35, -0.75), align_horizontal = ALIGN_UPPER},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0.25, -0.75)},
        {object = "blue", height = 0.1, position = Vectord.new(0.0, -0.75)},
        {object = "green", height = 0.1, position = Vectord.new(0.5, -0.75)},

        {object = "square", height = 0.2, position = Vectord.new(-0.35, -1), align_horizontal = ALIGN_UPPER},
        {image = "ArrowRight.png", width = 0.1, position = Vectord.new(0.25, -1)},
        {object = "green", height = 0.1, position = Vectord.new(0.0, -1)},
        {object = "blue", height = 0.1, position = Vectord.new(0.5, -1)}
      }),
      info_desc("The input will contain a mixture of triangles and squares. The output must be a mixture of blue and green blocks. Each time a triangle is input, a new block should be output, of the same color as the last one output (or blue to start with). When a square is input a new block should be output, of the opposite color as the last one output.\n See Examples tab for example.")
    }},
    {tab = "Example", contents = {
      info_title("Example"),
      info_desc("The input will being with the following sequence of 7 objects:"),
      low_level_figure({
        {text = "1", height = 0.06, position = Vectord.new(-0.75, 0.15), color = {1, 1, 1, 0.5}},
        {object = "triangle", height = 0.2, position = Vectord.new(-0.75, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(-0.75, -0.2)},
        {object = "blue", height = 0.1, position = Vectord.new(-0.75, -0.35)},

        {text = "2", height = 0.06, position = Vectord.new(-0.5, 0.15), color = {1, 1, 1, 0.5}},
        {object = "square", height = 0.2, position = Vectord.new(-0.5, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(-0.5, -0.2)},
        {object = "green", height = 0.1, position = Vectord.new(-0.5, -0.35)},

        {text = "3", height = 0.06, position = Vectord.new(-0.25, 0.15), color = {1, 1, 1, 0.5}},
        {object = "triangle", height = 0.2, position = Vectord.new(-0.25, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(-0.25, -0.2)},
        {object = "green", height = 0.1, position = Vectord.new(-0.25, -0.35)},

        {text = "4", height = 0.06, position = Vectord.new(0, 0.15), color = {1, 1, 1, 0.5}},
        {object = "triangle", height = 0.2, position = Vectord.new(0, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.2)},
        {object = "green", height = 0.1, position = Vectord.new(0, -0.35)},

        {text = "5", height = 0.06, position = Vectord.new(0.25, 0.15), color = {1, 1, 1, 0.5}},
        {object = "square", height = 0.2, position = Vectord.new(0.25, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0.25, -0.2)},
        {object = "blue", height = 0.1, position = Vectord.new(0.25, -0.35)},

        {text = "6", height = 0.06, position = Vectord.new(0.5, 0.15), color = {1, 1, 1, 0.5}},
        {object = "triangle", height = 0.2, position = Vectord.new(0.5, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0.5, -0.2)},
        {object = "blue", height = 0.1, position = Vectord.new(0.5, -0.35)},

        {text = "7", height = 0.06, position = Vectord.new(0.75, 0.15), color = {1, 1, 1, 0.5}},
        {object = "triangle", height = 0.2, position = Vectord.new(0.75, 0)},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0.75, -0.2)},
        {object = "blue", height = 0.1, position = Vectord.new(0.75, -0.35)}
      }),
      info_desc("The first input is always a triangle and the first output is blue by the specification. After that, we receive a square, so switch the color of the output to green. Then, the third input is a triangle, so we copy the prior green input. The fourth is also a triangle, so we output another green block. Then the fifth is a square, so we switch colors again. The next two are triangles, so copy the blue color.")
    }}
  },
  standard_resize = true
});

--[[  false,
  true,
  false,
  false,
  true,
  false,
  false,]]
